//------------------------------------------------------------
// Test Display
// 2024-02-27 RSP
// Target: RP2040 + any number of button pad modules
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
VelociBus_4X4BP vbus; // create VelociBus interface, one required for each serial port used
#define VBUS_SERIAL Serial2

void setup() 
{
  Serial.begin(115200);
  
  // button module on VelociBus
  VBUS_SERIAL.begin(38400); // VelociBus is always 38400
}

void loop() 
{
  vbus.begin( &VBUS_SERIAL );

  // listen for buttons
  for (uint32_t tm=millis(); millis()-tm < 1000UL; )
  { VelociBus_4X4BP::button_info btn;
    if (vbus.getButton( &btn ))
      switch (btn.button_index)
      {
        case 0: // all off
          vbus.setLEDall( btn.board_address, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );
          break;
          
        case 1: // random colors
          for (uint i=0; i < 16; i++)
            vbus.setLED( btn.board_address, i, VelociBus_4X4BP::FCN_COLOR, (VelociBus_4X4BP::color_code)random(1,16) );
          break;
        
        case 2: // brightness down
          vbus.bumpBrightness( -1 );
          break;
        case 3: // brightness up
          vbus.bumpBrightness( 1 );        
      }
  } 
}
